/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/**
 * \file    irrx.h
 *
 * \brief   irrx test routines
 *
 * IRrx header file
 *
 *
 *
 * 
 */
/*========================
 * Includes
 *========================
 */
 
#include "DM814x_types.h"
#include "DM814x_EVM.h"
#include "DM814x_uart.h"

/* ------------------------------------------------------------------------ *
 *  UART Handle                                                             *
 * ------------------------------------------------------------------------ */
typedef UINT32 UART_Handle;


/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
UINT32  UART_rget( UART_Handle uart, UINT32 reg );
void   UART_rset( UART_Handle uart, UINT32 reg, UINT32 reg_value );
INT16 init_cir( );
INT8 read_cir_value( );
INT16 uart_cir_test( );
